/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.computer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.report.computer.AbstractReportComputer;
import cz.insophy.inplan.report.result.MaterialFlowDetailTableRow;
import cz.insophy.inplan.report.result.MaterialFlowResult;
import cz.insophy.inplan.report.result.MaterialFlowSummaryTableRow;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgNodeVisitors;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.InPlanPtnStoreActivity;
import cz.insophy.inplan.store.MaterialRequest;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.Tuple;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MaterialFlowComputer
extends AbstractReportComputer<MaterialFlowResult> {
    private Material material = null;
    private static final InnerDataExtractor SRC_EXTRACTOR = new InnerDataExtractor(){

        @Override
        public MaterialFlowDetailTableRow.MaterialFlowInnerData extractInnerData(MaterialFlowDetailTableRow row) {
            return row.getSource();
        }

        @Override
        public double sign() {
            return 1.0;
        }
    };
    private static final InnerDataExtractor DEST_EXTRACTOR = new InnerDataExtractor(){

        @Override
        public MaterialFlowDetailTableRow.MaterialFlowInnerData extractInnerData(MaterialFlowDetailTableRow row) {
            return row.getDestination();
        }

        @Override
        public double sign() {
            return -1.0;
        }
    };

    public void setMaterial(Material material) {
        this.material = material;
    }

    @Override
    public MaterialFlowResult compute(Superplan superplan) {
        if (this.material == null) {
            return null;
        }
        StoreSchedule storeSchedule = superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        Multimap<Material, SdgEdge> edges = MaterialFlowComputer.processSuperplan(superplan);
        return MaterialFlowComputer.extractResult(this.material, edges, storeSchedule);
    }

    @Nonnull
    public Map<Material, MaterialFlowResult> computeAll(Superplan superplan) {
        HashMap<Material, MaterialFlowResult> results = Maps.newHashMap();
        StoreSchedule storeSchedule = superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        Multimap<Material, SdgEdge> edges = MaterialFlowComputer.processSuperplan(superplan);
        for (Material mat : superplan.getShopConf().getMatprods()) {
            results.put(mat, MaterialFlowComputer.extractResult(mat, edges, storeSchedule));
        }
        return results;
    }

    @Nonnull
    private static MaterialFlowResult extractResult(Material mat, Multimap<Material, SdgEdge> edges, StoreSchedule storeSchedule) {
        List<MaterialFlowDetailTableRow> detailDataGrouped;
        List<MaterialFlowDetailTableRow> detailDataUngrouped;
        if (edges.get(mat).isEmpty()) {
            detailDataUngrouped = Collections.emptyList();
            detailDataGrouped = Collections.emptyList();
        } else {
            detailDataUngrouped = MaterialFlowComputer.computeDetailRows(mat, edges, storeSchedule);
            detailDataGrouped = MaterialFlowComputer.computeGroupedRows(mat, edges, storeSchedule);
        }
        List<MaterialFlowSummaryTableRow> summaryData = MaterialFlowComputer.computeSummaryRows(mat, edges, storeSchedule);
        return new MaterialFlowResult(detailDataUngrouped, detailDataGrouped, summaryData, MaterialFlowComputer.computeGiveTakeRows(summaryData, true), MaterialFlowComputer.computeGiveTakeRows(summaryData, false));
    }

    private static Multimap<Material, SdgEdge> processSuperplan(Superplan superplan) {
        ArrayListMultimap<Material, SdgEdge> ret = ArrayListMultimap.create();
        for (SdgEdge edge : superplan.getSDGraph().getAllEdges()) {
            ret.put(edge.getMaterial(), edge);
        }
        return ret;
    }

    private static List<MaterialFlowSummaryTableRow> computeGiveTakeRows(List<MaterialFlowSummaryTableRow> rows, boolean positive) {
        ArrayList<MaterialFlowSummaryTableRow> data = Lists.newArrayListWithCapacity(rows.size());
        double remains = 0.0;
        for (MaterialFlowSummaryTableRow row : rows) {
            if (positive && row.getChange() <= 0.0 || !positive && row.getChange() >= 0.0) continue;
            data.add(new MaterialFlowSummaryTableRow(row.getDate(), row.getChange(), remains += row.getChange(), "N/A", row.getOriginatorName(), row.getOriginatorMaterial(), row.getOrinatorDueDate(), row.getOriginatorId(), row.getOriginatorType(), row.getNote()));
        }
        return Collections.unmodifiableList(data);
    }

    private static List<MaterialFlowSummaryTableRow> computeSummaryRows(Material material, Multimap<Material, SdgEdge> matsToEdges, StoreSchedule storeSchedule) {
        ArrayList<MaterialFlowSummaryTableRow> data = Lists.newArrayList();
        LinkedHashMultimap<StoreActivity, Object> destToSource = LinkedHashMultimap.create();
        for (SdgEdge edge : matsToEdges.get(material)) {
            destToSource.put(edge.getDestinationStoreActivity(), edge.getSourceNode().accept(SdgNodeVisitors.GET_CONTENTS));
        }
        ArrayList<StoreActivity> activities = Lists.newArrayList(storeSchedule.getActivities(material));
        activities.sort(Ordering.from(StoreActivity.timeQtyRevComparator()).nullsLast());
        for (StoreActivity activity : activities) {
            Object originator = activity.getOriginator();
            String srcName = MaterialFlowComputer.collectionToString(destToSource.get(activity));
            String originatorName = MaterialFlowComputer.objectToString(originator);
            Material originatorMaterial = MaterialFlowComputer.objectToMaterial(originator);
            long originatorDueDate = MaterialFlowComputer.objectToDueDate(originator);
            String originatorNote = MaterialFlowComputer.getNote(activity);
            String originatorId = MaterialFlowComputer.objectToId(originator);
            String originatorType = MaterialFlowComputer.objectToType(originator);
            long date = activity.getTime();
            double change = activity.getQty();
            double remains = storeSchedule.getQ(material, date, true);
            if ("~".equals(originatorName)) {
                date = -9223372036854775708L;
            }
            data.add(new MaterialFlowSummaryTableRow(date, change, remains, srcName, originatorName, originatorMaterial, originatorDueDate, originatorId, originatorType, originatorNote));
        }
        return Collections.unmodifiableList(data);
    }

    private static List<MaterialFlowDetailTableRow> computeDetailRows(Material material, Multimap<Material, SdgEdge> matsToEdges, StoreSchedule storeSchedule) {
        StoreActivity srcLast = null;
        double srcRemains = 0.0;
        StoreActivity destLast = null;
        double destRemains = 0.0;
        Collection<SdgEdge> edges = matsToEdges.get(material);
        ArrayList<MaterialFlowDetailTableRow> data = Lists.newArrayList();
        for (SdgEdge edge : edges) {
            Object srcObject = edge.getSourceNode().accept(SdgNodeVisitors.GET_CONTENTS);
            Object destObject = edge.getDestinationNode().accept(SdgNodeVisitors.GET_CONTENTS);
            String srcName = MaterialFlowComputer.objectToString(srcObject);
            String destName = MaterialFlowComputer.objectToString(destObject);
            boolean srcFresh = false;
            boolean destFresh = false;
            if (srcLast == null || edge.getSourceStoreActivity() != srcLast) {
                srcFresh = srcLast != null;
                srcLast = edge.getSourceStoreActivity();
                double d = srcRemains = srcLast == null ? 0.0 : srcLast.getQty();
            }
            if (destLast == null || edge.getDestinationStoreActivity() != destLast) {
                destFresh = destLast != null;
                destLast = edge.getDestinationStoreActivity();
                destRemains = destLast == null ? 0.0 : destLast.getQty();
            }
            Preconditions.checkState(srcRemains >= 0.0);
            Preconditions.checkState(destRemains <= 0.0);
            long srcDate = edge.getSourceStoreActivity() == null || "~".equals(srcName) ? -9223372036854775708L : edge.getStartTime();
            long destDate = edge.getDestinationStoreActivity() == null ? -9223372036854775708L : edge.getEndTime();
            long date = edge.getEndTime();
            double changeOriginal = Math.min(srcRemains, -destRemains);
            srcRemains -= changeOriginal;
            destRemains += changeOriginal;
            double changeFixed = Math.abs(changeOriginal) < 1.0E-7 ? 0.0 : changeOriginal;
            double remains = storeSchedule.getQ(material, date, true);
            double srcChange = edge.getSourceStoreActivity() == null ? 0.0 : edge.getSourceStoreActivity().getQty();
            double destChange = edge.getDestinationStoreActivity() == null ? 0.0 : edge.getDestinationStoreActivity().getQty();
            String srcNote = MaterialFlowComputer.getNote(edge.getSourceStoreActivity());
            String destNote = MaterialFlowComputer.getNote(edge.getDestinationStoreActivity());
            data.add(new MaterialFlowDetailTableRow(date, changeFixed, remains, MaterialFlowComputer.isCompletion(edge.getDestinationStoreActivity()), new MaterialFlowDetailTableRow.MaterialFlowInnerData(srcObject, srcName, srcFresh, srcDate, srcChange, srcRemains, srcNote, null), new MaterialFlowDetailTableRow.MaterialFlowInnerData(destObject, destName, destFresh, destDate, destChange, destRemains, destNote, null)));
        }
        return Collections.unmodifiableList(data);
    }

    private static List<MaterialFlowDetailTableRow> computeGroupedRows(Material material, Multimap<Material, SdgEdge> matsToEdges, StoreSchedule storeSchedule) {
        Multimap<Tuple<Object, Object>, ElementaryTransfer> groupedTransfers = MaterialFlowComputer.groupByStoreActivity(material, matsToEdges);
        ArrayList<MaterialFlowDetailTableRow> rows = Lists.newArrayListWithExpectedSize(groupedTransfers.size());
        for (Tuple<Object, Object> key : groupedTransfers.keySet()) {
            Object srcObject = key.getFirst();
            Object dstObject = key.getSecond();
            String srcName = MaterialFlowComputer.objectToString(srcObject);
            String dstName = MaterialFlowComputer.objectToString(dstObject);
            long date = Long.MIN_VALUE;
            long srcDate = -9223372036854775708L;
            long dstDate = -9223372036854775708L;
            double change = 0.0;
            String srcNote = null;
            String dstNote = null;
            double srcQty = 0.0;
            double dstQty = 0.0;
            boolean allCompletion = true;
            HashSet<StoreActivity> srcSas = Sets.newHashSet();
            HashSet<StoreActivity> dstSas = Sets.newHashSet();
            for (ElementaryTransfer et : groupedTransfers.get(key)) {
                if (et.srcSa != null) {
                    if (srcDate == -9223372036854775708L) {
                        srcDate = et.srcSa.getTime();
                    }
                    srcSas.add(et.srcSa);
                }
                if (et.dstSa != null) {
                    dstDate = et.dstSa.getTime();
                    dstSas.add(et.dstSa);
                }
                date = Math.max(date, dstDate);
                change += et.change;
                if (srcNote == null) {
                    srcNote = MaterialFlowComputer.getNote(et.srcSa);
                }
                if (dstNote == null) {
                    dstNote = MaterialFlowComputer.getNote(et.dstSa);
                }
                if (MaterialFlowComputer.isCompletion(et.dstSa)) continue;
                allCompletion = false;
            }
            for (StoreActivity sa : srcSas) {
                srcQty += sa.getQty();
            }
            for (StoreActivity sa : dstSas) {
                dstQty += sa.getQty();
            }
            double remains = GeneralizedRequest.isDateValid(date) ? storeSchedule.getQ(material, date, true) : storeSchedule.getInfTimeQty(material);
            if ("~".equals(srcName)) {
                srcDate = -9223372036854775708L;
            }
            rows.add(new MaterialFlowDetailTableRow(date, change, remains, allCompletion, new MaterialFlowDetailTableRow.MaterialFlowInnerData(srcObject, srcName, false, srcDate, srcQty, 0.0, srcNote, srcSas), new MaterialFlowDetailTableRow.MaterialFlowInnerData(dstObject, dstName, false, dstDate, dstQty, 0.0, dstNote, dstSas)));
        }
        MaterialFlowComputer.updateInnerData(SRC_EXTRACTOR, rows);
        MaterialFlowComputer.updateInnerData(DEST_EXTRACTOR, rows);
        if (rows.size() > 0) {
            ((MaterialFlowDetailTableRow)rows.get(0)).getSource().setFresh(false);
            ((MaterialFlowDetailTableRow)rows.get(0)).getDestination().setFresh(false);
        }
        return rows;
    }

    private static void updateInnerData(InnerDataExtractor ide, List<MaterialFlowDetailTableRow> rows) {
        Multimap<Integer, MaterialFlowDetailTableRow> groupedRows = MaterialFlowComputer.groupByOrigin(ide, rows);
        for (Integer groupKey : groupedRows.keySet()) {
            Set<StoreActivity> sas = Sets.newIdentityHashSet();
            for (MaterialFlowDetailTableRow row : groupedRows.get(groupKey)) {
                MaterialFlowDetailTableRow.MaterialFlowInnerData innerData = ide.extractInnerData(row);
                sas.addAll(innerData.getSas());
            }
            double qty = 0.0;
            for (StoreActivity sa : sas) {
                qty += sa.getQty();
            }
            double remains = qty;
            boolean fresh = true;
            for (MaterialFlowDetailTableRow row : groupedRows.get(groupKey)) {
                MaterialFlowDetailTableRow.MaterialFlowInnerData innerData;
                if (Math.abs(remains -= row.getChange() * ide.sign()) < 1.0E-7) {
                    remains = 0.0;
                }
                if ((innerData = ide.extractInnerData(row)).getOrigin() != null) {
                    innerData.setRemains(remains);
                }
                innerData.setQty(qty);
                innerData.setFresh(fresh);
                fresh = false;
            }
        }
    }

    private static Multimap<Integer, MaterialFlowDetailTableRow> groupByOrigin(InnerDataExtractor ide, List<MaterialFlowDetailTableRow> rows) {
        LinkedHashMultimap<Integer, MaterialFlowDetailTableRow> groupedRows = LinkedHashMultimap.create();
        Object lastOrigin = new Object();
        int key = 0;
        for (MaterialFlowDetailTableRow row : rows) {
            Object origin = ide.extractInnerData(row).getOrigin();
            if (lastOrigin != origin) {
                lastOrigin = origin;
                ++key;
            }
            groupedRows.put(key, row);
        }
        return Multimaps.unmodifiableMultimap(groupedRows);
    }

    private static Multimap<Tuple<Object, Object>, ElementaryTransfer> groupByStoreActivity(Material material, Multimap<Material, SdgEdge> matsToEdges) {
        HashBasedTable<Object, Object, Tuple> keys = HashBasedTable.create();
        LinkedHashMultimap<Tuple, ElementaryTransfer> grouped = LinkedHashMultimap.create();
        double srcRemains = 0.0;
        double dstRemains = 0.0;
        StoreActivity lastSrcSa = null;
        StoreActivity lastDstSa = null;
        for (SdgEdge edge : matsToEdges.get(material)) {
            Tuple key;
            Object o2;
            Object o1 = edge.getSourceNode().accept(SdgNodeVisitors.GET_CONTENTS);
            if (keys.contains(o1, o2 = edge.getDestinationNode().accept(SdgNodeVisitors.GET_CONTENTS))) {
                key = (Tuple)keys.get(o1, o2);
            } else {
                key = Tuple.create(o1, o2);
                keys.put(o1, o2, key);
            }
            StoreActivity srcSa = edge.getSourceStoreActivity();
            StoreActivity dstSa = edge.getDestinationStoreActivity();
            if (srcSa != lastSrcSa) {
                srcRemains = srcSa == null ? 0.0 : srcSa.getQty();
                lastSrcSa = srcSa;
            }
            if (dstSa != lastDstSa) {
                dstRemains = dstSa == null ? 0.0 : dstSa.getQty();
                lastDstSa = dstSa;
            }
            double change = Math.min(srcRemains, -dstRemains);
            srcRemains -= change;
            dstRemains += change;
            ElementaryTransfer transfer = new ElementaryTransfer(srcSa, dstSa, change);
            grouped.put(key, transfer);
        }
        return Multimaps.unmodifiableMultimap(grouped);
    }

    private static boolean isCompletion(StoreActivity sa) {
        return sa instanceof InPlanPtnStoreActivity && ((InPlanPtnStoreActivity)sa).getOwner() instanceof GeneralizedActionRequest;
    }

    private static String collectionToString(Collection<Object> objects) {
        if (objects != null) {
            StringBuilder sb = new StringBuilder();
            for (Object object : objects) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(MaterialFlowComputer.objectToString(object));
            }
            return sb.toString();
        }
        return "~";
    }

    private static String objectToString(Object object) {
        if (object instanceof ProductionTreeNode) {
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor((ProductionTreeNode)object);
            return Localizer.getString("gor.short.gor", gor.getId(), Localizer.getString("request_manager.state." + gor.getState().name().toLowerCase()));
        }
        if (object instanceof CustomerRequest) {
            CustomerRequest cr = (CustomerRequest)object;
            return Localizer.getString("gor.short.customer_request", cr.getId());
        }
        if (object instanceof SupplyRequest) {
            SupplyRequest sr = (SupplyRequest)object;
            return Localizer.getString("gor.short.supply_request", new Object[]{sr.getId(), sr.getState()});
        }
        return "~";
    }

    private static String objectToId(Object object) {
        if (object instanceof ProductionTreeNode) {
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor((ProductionTreeNode)object);
            return gor.getId();
        }
        if (object instanceof CustomerRequest) {
            CustomerRequest cr = (CustomerRequest)object;
            return cr.getId();
        }
        if (object instanceof SupplyRequest) {
            SupplyRequest sr = (SupplyRequest)object;
            return sr.getId();
        }
        return "~";
    }

    private static String objectToType(Object object) {
        if (object instanceof ProductionTreeNode) {
            return "order";
        }
        if (object instanceof CustomerRequest) {
            return "cr";
        }
        if (object instanceof SupplyRequest) {
            return "sr";
        }
        return "~";
    }

    private static long objectToDueDate(Object object) {
        if (object != null) {
            if (object instanceof ProductionTreeNode) {
                GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor((ProductionTreeNode)object);
                return gor.getDueDate();
            }
            if (object instanceof MaterialRequest) {
                MaterialRequest mr = (MaterialRequest)object;
                return mr.getTime();
            }
        }
        return -9223372036854775708L;
    }

    private static Material objectToMaterial(Object object) {
        if (object instanceof ProductionTreeNode) {
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor((ProductionTreeNode)object);
            return gor.getProduct();
        }
        if (object instanceof CustomerRequest) {
            return ((CustomerRequest)object).getMaterial();
        }
        if (object instanceof SupplyRequest) {
            return ((SupplyRequest)object).getMaterial();
        }
        return null;
    }

    private static String getNote(StoreActivity sa) {
        if (sa == null) {
            return "~";
        }
        return Formatter.getStoreActivityDetail(sa, NumberFormat.getInstance(), false, false);
    }

    private static class ElementaryTransfer {
        private StoreActivity srcSa;
        private StoreActivity dstSa;
        protected double change;

        private ElementaryTransfer(StoreActivity srcSa, StoreActivity dstSa, double change) {
            this.srcSa = srcSa;
            this.dstSa = dstSa;
            this.change = change;
        }
    }

    private static interface InnerDataExtractor {
        public MaterialFlowDetailTableRow.MaterialFlowInnerData extractInnerData(MaterialFlowDetailTableRow var1);

        public double sign();
    }
}

